function [p,x] = densityKessler(model,x,x0,dt,theta)
% Computes the density using the Kessler (1997) method

    switch model
        case 'ou'
            b = theta(1)*(theta(2)-x0);
            bx = -theta(1);
            bxx = 0;
            c = theta(3)^2;
            cx = 0;
            cxx = 0;
        case 'cir'
            b = theta(1)*(theta(2)-x0);
            bx = -theta(1);
            bxx = 0;
            c = theta(3)^2*x0;
            cx = theta(3)^2;
            cxx = 0;
    end

    meanApprox = x0+ dt*b + (dt^2/2)*(b*bx + .5*c*bxx);
    varApprox = dt*c + dt^2*(.5*b*cx + c*bx + .25*c*cxx);

    p = normpdf(x,meanApprox,sqrt(varApprox));

end