function [p,x] = densityShojiOzaki(model,x,x0,dt,theta)
% Computes the density using the Shoji-Ozaki method

numPoints = length(x);

switch lower(model)
    case 'ou'
        % Gamma transform
        kappa = theta(1); alpha = theta(2); beta = theta(3);
        y = x/beta;
        y0 = x0/beta;
        sigmaOfx = beta*(ones(size(x)));
        
        % Deal coeffs
        a0 = kappa*alpha/beta-kappa*y0;
        a1 = -kappa;
        a2 = 0;
        
        % SO approx
        p = calcDensity(y,y0,dt,a0,a1,a2)./sigmaOfx; 
    case 'cir'
        % Gamma transform
        kappa = theta(1); alpha = theta(2); beta = theta(3);
        y = 2*sqrt(x)/beta;
        y0 = 2*sqrt(x0)/beta;
        sigmaOfx = beta*sqrt(x);
        
        % Deal coeffs
        foo = 2*kappa*alpha/beta^2-1/2;
        a0 = foo/y0 - kappa/2*y0;
        a1 = -foo/y0^2 - kappa/2;
        a2 = 2*foo/y0^3;
        
        % SO approx
        p = calcDensity(y,y0,dt,a0,a1,a2)./sigmaOfx;
   otherwise
      p = zeros(size(x));
end

end

% ----------------------------------------------------------------------
function p = calcDensity(x,x0,dt,a0,a1,a2)
sigma = 1;
L = a1;
M = 1/2*sigma^2*a2;
p = normpdf(x,...
   x0 + a0/L*(exp(L*dt)-1) + M/L^2*(exp(L*dt)-1-L*dt),...
   sqrt(sigma^2*(exp(2*L*dt)-1)/(2*L)));
end
