function [errSum,numErr,rank,negAndTime] = errorSummary(model,theta,errTable_exact,errTable_epsilon2,errTable_as2,errTable_so,errTable_k,reduce)
    % Count optimization error problems
    % Optim flag <= 0 (convergence problem)
    problemInd1_exact = optimFail1(errTable_exact);
    problemInd1_epsilon2 = optimFail1(errTable_epsilon2);
    problemInd1_as2 = optimFail1(errTable_as2);
    problemInd1_k = optimFail1(errTable_k);
    % |theta|>100
    problemInd2_exact = optimFail2(errTable_exact);
    problemInd2_epsilon2 = optimFail2(errTable_epsilon2);
    problemInd2_as2 = optimFail2(errTable_as2);
    problemInd2_k = optimFail2(errTable_k);
    switch model
        case 'ou'
            numErr1 = sum([problemInd1_exact,problemInd1_epsilon2,problemInd1_as2,problemInd1_k]);
            numErr2 = sum([problemInd2_exact,problemInd2_epsilon2,problemInd2_as2,problemInd2_k]);
            numErr = [numErr1;numErr2];
            problemInd = problemInd1_exact | problemInd1_epsilon2 | problemInd1_as2 | problemInd1_k | ...
                         problemInd2_exact | problemInd2_epsilon2 | problemInd2_as2 | problemInd2_k;
        case 'cir'
            problemInd1_so = optimFail1(errTable_so);
            problemInd2_so = optimFail2(errTable_so);
            numErr1 = sum([problemInd1_exact,problemInd1_epsilon2,problemInd1_as2,problemInd1_so,problemInd1_k]);
            numErr2 = sum([problemInd2_exact,problemInd2_epsilon2,problemInd2_as2,problemInd2_so,problemInd2_k]);
            numErr = [numErr1;numErr2];
            problemInd = problemInd1_exact | problemInd1_epsilon2 | problemInd1_as2 | problemInd1_so | problemInd1_k | ...
                         problemInd2_exact | problemInd2_epsilon2 | problemInd2_as2 | problemInd2_so | problemInd2_k;
    end

    % Get error summary (computes median error and RMSE)
    errSum_exact = errorSummaryCol(errTable_exact,problemInd1_exact|problemInd2_exact,reduce);
    errSum_epsilon2 = errorSummaryCol(errTable_epsilon2,problemInd1_epsilon2|problemInd2_epsilon2,reduce);
    errSum_as2 = errorSummaryCol(errTable_as2,problemInd1_as2|problemInd2_as2,reduce);
    errSum_k = errorSummaryCol(errTable_k,problemInd1_k|problemInd2_k,reduce);
    switch model
        case 'ou'
            errSum = [errSum_exact,errSum_epsilon2,errSum_as2,errSum_k];
        case 'cir'
            errSum_so = errorSummaryCol(errTable_so,problemInd1_so|problemInd2_so,reduce);
            errSum = [errSum_exact,errSum_epsilon2,errSum_as2,errSum_so,errSum_k];
    end
    errSum = errSum(:,2:end);

    % Rank based on lowest error
    [~,nCols] = size(errSum);
    thetaMat = repmat(theta',1,(nCols-1)/2);
    sum1 = mean(errSum([1 3 5],[false,false,mod(3:nCols,2)==1])./thetaMat);
    sum2 = mean(errSum([2 4 6],[false,false,mod(3:nCols,2)==1])./thetaMat);
    rank = [0, ranking(sum1); 0, ranking(sum2)];
   
   % Count negative problems and time
    nc_exact = sum(errTable_exact(:,8:9))';
    nc_epsilon2 = sum(errTable_epsilon2(:,8:9))';
    nc_as2 = sum(errTable_as2(:,8:9))';
    nc_k = sum(errTable_k(:,8:9))';
    switch model
        case 'ou'
            negAndTime = [nc_exact,nc_epsilon2,nc_as2,nc_k];
        case 'cir'
            nc_so = sum(errTable_so(:,8:9))';
            negAndTime = [nc_exact,nc_epsilon2,nc_as2,nc_so,nc_k];
    end
end

function [errSumCol] = errorSummaryCol(errTable,problemInd,reduce)
    if reduce == true
        errTable = errTable(problemInd == false,:);
    end
    errSumMed = median(errTable(:,1:3),1);
    errSumRMS = sqrt(mean(errTable(:,1:3).^2,1));
    errSumCol = [errSumMed',errSumRMS']';
    errSumCol1 = errSumCol(:);
    errSumMed = median(errTable(:,4:6),1);
    errSumRMS = sqrt(mean(errTable(:,4:6).^2,1));
    errSumCol = [errSumMed',errSumRMS']';
    errSumCol2 = errSumCol(:);
    errSumCol = [errSumCol1,errSumCol2];
end

function [problemInd] = optimFail1(errTable)
    problemInd = isnan(errTable(:,7)) | errTable(:,7) <= 0;
end

function [problemInd] = optimFail2(errTable)
    problemInd = abs(errTable(:,4)) > 100 | abs(errTable(:,5)) > 100 | abs(errTable(:,6)) > 100 ;
end

function [r] = ranking(x)
    [~,p] = sort(x);
    r = 1:length(x);
    r(p) = r;
end
