function [errSum,numErr,rank] = estimate(nSim,n,dt,model,absval,seeds,outputname)
%     options = optimoptions(@fminunc);
%     options.Display = 'off';

    switch model
        case 'ou'
            theta = [0.0717,0.261,0.02237];
            x0 = 0.1;
            nu = NaN;
            ct = NaN;
        case 'cir1'
            theta = [0.5,0.06,0.15];
            x0 = 0.1;
            nu = 4*theta(1)*theta(2)/theta(3)^2;
            ct = 2*theta(1)/(theta(3)^2*(1-exp(-theta(1)*dt)));
            model = 'cir';
        case 'cir2'
            theta = [1,1,0.3];
            x0 = 2;
            nu = 4*theta(1)*theta(2)/theta(3)^2;
            ct = 2*theta(1)/(theta(3)^2*(1-exp(-theta(1)*dt)));
            model = 'cir';
        case 'cir3'
            theta = [0.2,3,0.2];
            x0 = 1;
            nu = 4*theta(1)*theta(2)/theta(3)^2;
            ct = 2*theta(1)/(theta(3)^2*(1-exp(-theta(1)*dt)));
            model = 'cir';
    end

    errTable_exact = NaN(nSim,9);
    errTable_epsilon2 = NaN(nSim,9);
    errTable_as2 = NaN(nSim,9);
    errTable_so = NaN(nSim,9);
    errTable_k = NaN(nSim,9);

    parfor j = 1:nSim
        disp(j);
        rng(seeds(j),'twister');
        % Simulate process
        x = zeros(n,1);
        switch model
            case 'ou'
                for i = 1:n
                   if i == 1
                       x(1) = x0;
                   else
                       x(i) = theta(2)*(1-exp(-theta(1)*dt))+x(i-1)*exp(-theta(1)*dt) + ...
                       theta(3)/sqrt(2*theta(1))*sqrt(1-exp(-2*theta(1)*dt))*randn(1);
                   end
                end
            case 'cir'
                for i = 1:n
                   if i == 1
                       x(1) = x0;
                   else
                       x(i) = ncx2rnd(nu,2*ct*x(i-1)*exp(-theta(1)*dt))/(2*ct);
                   end
                end
        end

        % Optimize for theta
        try
            tic
            f = @(theta) objectiveFunction(model,x,dt,theta,'exact',absval);
            [thetaEstExact,~,exitflag] = fminsearch(f,theta);
%             [thetaEstExact,~,exitflag] = fminunc(f,theta,options);
            tt = toc;
            errTable_exact(j,:) = [0,0,0,abs(thetaEstExact-theta),exitflag,0,tt];
        end

        try
            tic
            f = @(theta) objectiveFunction(model,x,dt,theta,'epsilon2_t',absval);
            [thetaEst,~,exitflag] = fminsearch(f,theta);
%             [thetaEst,~,exitflag] = fminunc(f,theta,options);
            tt = toc;
            [~,~,negProb] = objectiveFunction(model,x,dt,theta,'epsilon2_t',absval);
            errTable_epsilon2(j,:) = [abs(thetaEst-theta),abs(thetaEst-thetaEstExact),exitflag,negProb,tt];
        end

        try
            tic
            f = @(theta) objectiveFunction(model,x,dt,theta,'as2',absval);
            [thetaEst,~,exitflag] = fminsearch(f,theta);
%             [thetaEst,~,exitflag] = fminunc(f,theta,options);
            tt = toc;
            [~,~,negProb] = objectiveFunction(model,x,dt,theta,'as2',absval);
            errTable_as2(j,:) = [abs(thetaEst-theta),abs(thetaEst-thetaEstExact),exitflag,negProb,tt];
        end

        switch model
            case 'cir'
                try
                    tic
                    f = @(theta) objectiveFunction(model,x,dt,theta,'so',absval);
                    [thetaEst,~,exitflag] = fminsearch(f,theta);
%                     [thetaEst,~,exitflag] = fminunc(f,theta,options);
                    tt = toc;
                    [~,~,negProb] = objectiveFunction(model,x,dt,theta,'so',absval);
                    errTable_so(j,:) = [abs(thetaEst-theta),abs(thetaEst-thetaEstExact),exitflag,negProb,tt];
                end
        end
        
        try
            tic
            f = @(theta) objectiveFunction(model,x,dt,theta,'k',absval);
            [thetaEst,~,exitflag] = fminsearch(f,theta);
%             [thetaEst,~,exitflag] = fminunc(f,theta,options);
            tt = toc;
            [~,~,negProb] = objectiveFunction(model,x,dt,theta,'k',absval);
            errTable_k(j,:) = [abs(thetaEst-theta),abs(thetaEst-thetaEstExact),exitflag,negProb,tt];
        end
    end
    
    [errSum,numErr,rank,negAndTime] = errorSummary(model,theta,errTable_exact,errTable_epsilon2,...
        errTable_as2,errTable_so,errTable_k,true);
    [~,nCols] = size(errSum);
    miscInfo = zeros(6,nCols);
    miscInfo(:,mod(1:nCols,2)==1) = [rank;numErr;negAndTime];
    
    save(strcat(outputname(1:(end-4)),'.mat'));
    writematrix([errSum;miscInfo],outputname);
end

