% Generates the table of numerical results for the various approximate
% transition densities and their estimators
% OU: theta = [0.0717,0.261,0.02237]; x0 = 0.1;
% CIR1: theta = [0.5,0.06,0.15]; x0 = 0.1;
% CIR2: theta = [1,1,0.3]; x0 = 2;
% CIR3: theta = [0.2,3,0.2]; x0 = 1;

clear

rng(47182);
seedCum = randi(1e5,1);

nSim = 5000;
n = 1001;

%% vary dt
absval = true;

dt = 0.5/12;
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'ou',absval,seeds,'abs-ou-dt1.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir1',absval,seeds,'abs-cir1-dt1.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir2',absval,seeds,'abs-cir2-dt1.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir3',absval,seeds,'abs-cir3-dt1.csv');

dt = 1/12;
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'ou',absval,seeds,'abs-ou-dt2.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir1',absval,seeds,'abs-cir1-dt2.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir2',absval,seeds,'abs-cir2-dt2.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir3',absval,seeds,'abs-cir3-dt2.csv');

dt = 3/12;
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'ou',absval,seeds,'abs-ou-dt3.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir1',absval,seeds,'abs-cir1-dt3.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir2',absval,seeds,'abs-cir2-dt3.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir3',absval,seeds,'abs-cir3-dt3.csv');


%% dt = 12/12

dt = 12/12;
absval = true;

rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'ou',absval,seeds,'abs-ou-dt4.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir1',absval,seeds,'abs-cir1-dt4.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir2',absval,seeds,'abs-cir2-dt4.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir3',absval,seeds,'abs-cir3-dt4.csv');


%% vary n
dt = 1/12;
absval = true;

n= 501;
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'ou',absval,seeds,'abs-ou-n500.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir1',absval,seeds,'abs-cir1-n500.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir2',absval,seeds,'abs-cir2-n500.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir3',absval,seeds,'abs-cir3-n500.csv');

n = 2001;
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'ou',absval,seeds,'abs-ou-n2000.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir1',absval,seeds,'abs-cir1-n2000.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir2',absval,seeds,'abs-cir2-n2000.csv');
rng(seedCum+1); seeds = seedCum+1+cumsum(randi(1e3,1,nSim)); seedCum = seeds(end);
estimate(nSim,n,dt,'cir3',absval,seeds,'abs-cir3-n2000.csv');

