function [figHandle] = generatePlotFunc(model,x,dt,outputname)


    switch model
        case 'ou'
            theta = [0.0717,0.261,0.02237];
            x0 = 0.1;
        case 'cir1'
            theta = [0.5,0.06,0.15];
            x0 = 0.1;
            model = 'cir';
        case 'cir2'
            theta = [1,1,0.3];
            x0 = 2;
            model = 'cir';
        case 'cir3'
            theta = [0.2,3,0.2];
            x0 = 1;
            model = 'cir';
    end
    
    switch model
        case 'ou'
            f_true = densityExact('ou',x,x0,dt,theta);

            f_epsilon2 = PPWdensity('ou',x,x0,dt,theta,'epsilon2_t');
            f_as2 = densityASVectorized('ou',x,x0,dt,theta,2);
            f_k = densityKessler('ou',x,x0,dt,theta);

            q_epsilon2 = absErrorOfLogDensity(f_epsilon2,f_true);
            q_as2 = absErrorOfLogDensity(f_as2,f_true);
            q_k = absErrorOfLogDensity(f_k,f_true);

            figHandle = figure;
            a1=subplot(2,1,1);a2=subplot(2,1,2);subplotspace('vertical',-18);
            set(gcf,'Position',[160 65 560 1031]);
            axes(a1); box; 
            plot(x,f_epsilon2,'-',x,f_as2,'-.m',x,f_k,'--r',x,f_true,'-g')
            xlim([x(1) x(end)]);
            legendHandle = legend('epsilon','AS','Kessler','Exact');
            set(legendHandle,'FontSize',12);
            xlabel('x')
            ylabel('Density')

            axes(a2); box;
            plot(x,q_epsilon2,'-',x,q_as2,'-.m',x,q_k,'--r')
            xlabel('x')
            ylabel('AELD')
            set(gca,'YScale','log');
            xlim([x(1) x(end)]);
%             set(gcf,'PaperPosition',[3 6.2  14.5  21]);
            saveas(gcf,outputname);
            
        case 'cir'
            f_true = densityExact('cir',x,x0,dt,theta);

            f_epsilon2 = PPWdensity('cir',x,x0,dt,theta,'epsilon2_t');
            f_as2 = densityASVectorized('cir',x,x0,dt,theta,2);
            f_so = densityShojiOzaki('cir',x,x0,dt,theta);
            f_k = densityKessler('cir',x,x0,dt,theta);

            q_epsilon2 = absErrorOfLogDensity(f_epsilon2,f_true);
            q_as2 = absErrorOfLogDensity(f_as2,f_true);
            q_so = absErrorOfLogDensity(f_so,f_true);
            q_k = absErrorOfLogDensity(f_k,f_true);

            figHandle = figure;
            a1=subplot(2,1,1);a2=subplot(2,1,2);subplotspace('vertical',-18);
            set(gcf,'Position',[160 65 560 1031]);
            axes(a1); box; 
            plot(x,f_epsilon2,'-',x,f_as2,'-.m',x,f_so,'-.',x,f_k,'--r',x,f_true,'-g')
            xlim([x(1) x(end)]);
            legendHandle = legend('epsilon','AS','SO','Kessler','Exact');
            set(legendHandle,'FontSize',12);
            xlabel('x')
            ylabel('Density')

            axes(a2); box;
            plot(x,q_epsilon2,'-',x,q_as2,'-.m',x,q_so,'-.',x,q_k,'--r')
            xlabel('x')
            ylabel('AELD')
            set(gca,'YScale','log');
            xlim([x(1) x(end)]);
%             set(gcf,'PaperPosition',[3 6.2  14.5  21]);
            saveas(gcf,outputname);
    end
end

