% Generates the graphs for the exact and approximate transition densities
% OU: theta = [0.0717,0.261,0.02237]; x0 = 0.1;
% CIR1: theta = [0.5,0.06,0.15]; x0 = 0.1;
% CIR2: theta = [1,1,0.3]; x0 = 2;
% CIR3: theta = [0.2,3,0.2]; x0 = 1;

% OU
x = linspace(0.05,0.15,1000);
dt = 0.5/12;
graph = generatePlotFunc('ou',x,dt,'ou-dt1.pdf');
dt = 1/12;
graph = generatePlotFunc('ou',x,dt,'ou-dt2.pdf');
dt = 3/12;
graph = generatePlotFunc('ou',x,dt,'ou-dt3.pdf');

% CIR1
x = linspace(0.02,0.22,1000);
dt = 0.5/12;
graph = generatePlotFunc('cir1',x,dt,'cir1-dt1.pdf');
dt = 1/12;
graph = generatePlotFunc('cir1',x,dt,'cir1-dt2.pdf');
dt = 3/12;
graph = generatePlotFunc('cir1',x,dt,'cir1-dt3.pdf');

% CIR2
x = linspace(1.1,2.5,1000);
dt = 0.5/12;
graph = generatePlotFunc('cir2',x,dt,'cir2-dt1.pdf');
dt = 1/12;
graph = generatePlotFunc('cir2',x,dt,'cir2-dt2.pdf');
dt = 3/12;
graph = generatePlotFunc('cir2',x,dt,'cir2-dt3.pdf');

% CIR3
x = linspace(0.7,1.5,1000);
dt = 0.5/12;
graph = generatePlotFunc('cir3',x,dt,'cir3-dt1.pdf');
dt = 1/12;
graph = generatePlotFunc('cir3',x,dt,'cir3-dt2.pdf');
dt = 3/12;
graph = generatePlotFunc('cir3',x,dt,'cir3-dt3.pdf');


% dt = 12/12
dt = 12/12;
x = linspace(0.02,0.22,1000);
graph = generatePlotFunc('ou',x,dt,'ou-dt4.pdf');
x = linspace(0.001,0.35,1000);
graph = generatePlotFunc('cir1',x,dt,'cir1-dt4.pdf');
x = linspace(0.3,2.7,1000);
graph = generatePlotFunc('cir2',x,dt,'cir2-dt4.pdf');
x = linspace(0.6,2.3,1000);
graph = generatePlotFunc('cir3',x,dt,'cir3-dt4.pdf');