function [negLogLik,denVal,negProb] = objectiveFunction(model,x,dt,theta,method,absval)
% Computes the negative log liklihood from the the approximate densities

    n = length(x);
    denVal = zeros(n-1,1);
    switch method
        case 'exact'
            for i = 2:n
                denVal(i-1) = densityExact(model,x(i),x(i-1),dt,theta);
            end
        case {'epsilon1_t','epsilon2_t'}
           for i = 2:n;
                denVal(i-1) = PPWdensity(model,x(i),x(i-1),dt,theta,method);
           end
        case 'as1'
           for i = 2:n
                denVal(i-1) = densityAS(model,x(i),x(i-1),dt,theta,1);
           end
        case 'as2'
           for i = 2:n
                denVal(i-1) = densityAS(model,x(i),x(i-1),dt,theta,2);
           end
        case 'so'
            for i = 2:n
                denVal(i-1) = densityShojiOzaki(model,x(i),x(i-1),dt,theta);
            end
        case 'k'
            for i = 2:n
                denVal(i-1) = densityKessler(model,x(i),x(i-1),dt,theta);
           end
        otherwise
            error('Error: Invalid case.')
    end
    
    if sum(denVal<=0) > 0
        negProb = true;
    else
        negProb = false;
    end
    
    if absval == true
        invalidInd = isnan(denVal);
        denVal(invalidInd == false) = max(abs(denVal(invalidInd == false)),eps);
    end
    negLogLik = -sum(log(denVal));
end


