function [invV, mu0, ksi1, ksi2] = ESAG3parameterisation(param)
%ESAG3parameterisation : This function is called in ESAGsim and ESAGdensity
%and calculates the inverse of the matrix V, given in the parameterisation
%of the ESAG distribution in the referenced paper.
%
%Input:
%
% param : (mu gamma) as 1x3 and 1x2 row vectors respectively.
%
%Output:
%
% invV : 3 x 3 matrix as defined in the ESAG paper
%
% mu0 : scalar
%
% ks1 : major axis direction
%
% ksi2  : minor axis direction
%
%Reference: ESAG Paper (2015).

%% main body:


mu = [param(1) ; param(2) ; param(3)];
gamma1 = param(4);
gamma2 = param(5);


mu0 = sqrt(mu(2)^2 + mu(3)^2);
ksi1 = 1/(mu0*norm(mu))*[-mu0^2 ; mu(1)*mu(2) ; mu(1)*mu(3) ];
ksi2 = 1/mu0*[0 ; - mu(3) ; mu(2) ];
invV = eye(3) + gamma1*(ksi1*ksi1' - ksi2*ksi2') +...
    gamma2*(ksi1*ksi2' + ksi2*ksi1') +...
    (sqrt(1 + gamma1^2 + gamma2^2) - 1)*(ksi1*ksi1' + ksi2*ksi2');

end