Y = csvread('tasmanianData.csv'); 

figure; plotSphere();
plotPointsOnSphere(Y);
view(230,35); 
 
parHat = ESAGmle(Y); 

meanDir = parHat(1:3)/norm(parHat(1:3)); 

plotPointsOnSphere(meanDir,'y'); 

ESAGdensity([0 1 0]', parHat); 
 
plotContoursESAG(parHat,[0.9 0.5 0.1]);

n = 1e6;
par = [0 0 5 0.4 0];
X = ESAGsim(par,n); 

parToFit = [1 1 1 0 0];
par0 = [1 1 1 0 0];
[~, fIAG] = ESAGmle(Y,[],par0,parToFit); 

[~, fESAG] = ESAGmle(Y); 

T = 2*(fIAG - fESAG);

pval = 1 - chi2cdf(T,2); 