function p = ESAGdensity(x,param)
%ESAGdensity : Code evaluates  the density of the (elliptically symmetric) 
%angular Gaussian distribution at x on S^2 given the parameters.
%
% p = ESAGdensity(x, param)
%
%Input:
%
% x : 3 x n vector of Euclidean coordinates on the sphere to evalaute the
% density at.
%
% param : (mu gamma) - mu = 1x3 mean direction vector and gamma = 1x2
%vector.
%
%Output:
%
% p : output of the ESAG density at x given parameters param.
%
%Example:
%
% p = ESAGdensity([0 0;0 1;1 0], [0 0 1 0 0]);
%
%Reference: ESAG Paper (2015).

if size(param,1) > size(param,2), param = param'; end

%% Density Calculation:
[~,n] = size(x);
mu = param(1:3);
invV = ESAG3parameterisation(param);
p = NaN(1,n);
for i=1:n
    p(i) = ESAGdens(x(:,i),mu, invV);
end

end

function f_x = ESAGdens(x,mu, invV)
%Calculates the density for a single point on S^2.
C1 = x'*invV*x;
C2 = x'*mu';
C3 = mu*mu';

if C1 < 0 %and therefore sqrt(C1) is not real
  f_x = - inf;
else
  alpha = C2/sqrt(C1);
  M2 = (1 + alpha^2)*normcdf(alpha) + alpha*normpdf(alpha);
  f_x = 1/(2*pi)*C1^(-3/2)*exp(1/2*( alpha^2 - C3))*M2;

end

end
