function SphericalData = ESAGsim(param,n)
%ESAGsim : Code generates elliptically symmetric angular Gaussian 
%observations on the sphere S^2 using the [mu gamma] parameterisation 
%given in [1].
%
% Inputs:
%
%    param: a 1x5 vector structured as [mu gamma] where mu is 1x3 vector 
%    controlling mean direction and level of dispersion and gamma is a 
%    1x2 vector controlling the orientation and eccentricity of the 
%    contours.
%
%    n : sample size.
%
% Output:
%
%    SphericalData : 3 x n matrix of n observations from ESAG distribution.
%
% Example: 
%
%    Y = ESAGsim( [-3 -3 2 1 1], 50); 
%    figure; plotSphere;
%    plotPointsOnSphere(Y);
%
% Ref: 
%    [1] Paine, P.J., Preston, S.P., Tsagris, M., Wood, A.T.A., An elliptically symmetric angular Gaussian distribution,  Stat Comput (2017). doi:10.1007/s11222-017-9756-4ESAG Paper (2015)

%% Main Body:

invV = ESAG3parameterisation(param);

x = mvnrnd(param(1:3)',inv(invV),n);
x=x';
SphericalData=NaN(3,n);
for i=1:n
 SphericalData(:,i) = x(:,i)/norm(x(:,i)); 
end
 
 
end