function RotationMat = RotateVtoV(a,b)
%RotateVtoV : Rotation matrix for moving vector a onto vector b on the 
%sphere.
%
% RotationMat = RotateVtoV(a,b)
%Input: 
% a : initial vector 3 x 1 on S^2
%
% b : vector to rotate a onto, also 3 x 1 on S^2.
%
%Output:
%
% RotationMat : 3 x 3 matrix that rotates vector a onto vector b on the
% sphere, that is b = R*a.
%
% Reference: 

v = cross(a,b);
c = dot(a,b); %cos theta
s = norm(v); %sin theta
vSkewSym = [0 -v(3) v(2) ; v(3) 0 -v(1) ; -v(2) v(1) 0];
RotationMat = eye(3) + vSkewSym + vSkewSym^2*(1-c)/s^2;


end