function contourLevel = contourProbLevelsESAG(param, alpha, m)
%contourProbLevelsESAG : Calculates the contour levels for the log of the
%ESAG density for a given set of parameters and probability levels.
%
%Input:
% 
% contourProbLevelsESAG(param, alpha)
%
% param : parameters that define the ESAG density
%
% alpha : vector of % prob. levels in ascending order
%
% If nargin == 2 then m is set to 50000 as a default.
%
% contourProblevelsESAG(param, alpha, m)
%
% m : number of draws from the ESAG distribution
%
%Output:
%
% contourLevel : vector of contour levels for the log of the ESAG density
%
%Example:
%
% param = [0.5 2 3 0.3 0];
% alpha = [0.5 0.75 0.9 0.95];
% Clevel = contourProbLevelsESAG(param, alpha);

%% Body:

if nargin == 2
    m = 100000*length(alpha);
end

y = ESAGsim(param, m);
f = log(ESAGdensity(y,param)); 


q = sort(f,'ascend');

for k=1:length(alpha)
    index = m*(1 - alpha(k));
    index_ = int64(index);
    contourLevel(k) = q(index_);
    
end



end