function sphereData = exponentialMap(X)
%exponentialMap : Exponential map from tangent plane at (0,0,1) to sphere. 
%
% sphereData = exponentialMap(X)
%
%Input:
%
% X : 2 x n matrix of points on the tangent plane at (0,0,1)
%
%Output:
%
% sphereData : 3 x n points on the sphere S^2 as the exponential map from
% the tangent plane.
%
%Example:
% exponentialMap( [0.5 0.1] );

%% Body:

[~,n] = size(X);
sphereData = NaN(3,n);
mu = [0;0;1];
for i=1:n 
    V = [X(1,i) ; X(2,i) ; 1]; %z is fixed to be -1.
    angle = norm(V - mu);
    sphereData(:,i) = cos(angle)*mu + sin(angle)*(V-mu)/angle;    
end

end