function [x,y,z]=extractSphereContour(C)
%extractSphereContour : extracts the coordinates from contours plotted
%using matlab's contour or contourc in-built functions.
%
% [x,y,z] = extractSphereContour(C)
%
% INPUT:
% C : Output of contour or contourc.
%
% OUTPUT: 
%
%[x,y,z] : coordinates of points on the contours.
%
% Example:
% See contourPlotSphere for an example of how to use this function. 

%% Body:

n1 = 0; d = [];
while n1<size(C,2)
  n1 = n1+1;
  d = [d; C(:,n1+1:n1+C(2,n1))'; NaN NaN];
  n1 = n1+C(2,n1);
end

%exponential map to the sphere
sphereData = exponentialMap(d');
x = sphereData(1,:);
y = sphereData(2,:);
z = sphereData(3,:);



end



