function [] = plotContoursESAG(par,levels,line_style,levels_means_coverage)

if nargin < 4, levels_means_coverage = 1; end
if nargin < 3, line_style = 'b'; end
if nargin < 2, levels = [0.9 0.5 0.1]; end

if levels_means_coverage
   logLikVals = contourProbLevelsESAG(par',levels); 
else
   logLikVals = levels;
end

[xESAG, yESAG, zESAG, RESAG] = getCurveCoords(par',logLikVals,301);

for k = 1:length(levels)
   cESAG = RESAG*[xESAG{k}; yESAG{k}; zESAG{k}];
   plot3(cESAG(1,:),cESAG(2,:),cESAG(3,:),line_style);   %plot the contours
end




function [x,y,z,R] = getCurveCoords(param, contourLevel, n)

if nargin < 3
    n = 201;
end

rho = sqrt(2);
tangSpace = linspace(-rho,rho,n);
alpha = norm(param(1:3));
unitMu = [param(1);param(2);param(3)]/alpha;
if param(1) == 0 && param(2) == 0
    R = eye(3);
else
    R = RotateVtoV([0;0;1], unitMu);
end
densityESAGExpTangent = NaN(n,n);

for i=1:n
    for j=1:n
        
            %% Exponential map:   
            
            V = [tangSpace(i) ; tangSpace(j) ; 1]; %z is fixed to be 1.              
            z_Sphere = exponentialMap(V);
            Z = R*z_Sphere;
            
            densityESAGExpTangent(j,i) = log(ESAGdensity(Z, param));                   
           
    end
end

[X,Y,Z] = sphere(200);
p = size(X,1);
densityESAGExpSphere = NaN(size(X));
for k1 = 1:p
    for k2 = 1:p
        densityESAGExpSphere(k1,k2) = log(ESAGdensity([X(k1,k2),Y(k1,k2),...
            Z(k1,k2)]',param));
    end
end

%% Contour plot 

for k=1:length(contourLevel)
    C=contourc(tangSpace,tangSpace,densityESAGExpTangent,...
        [contourLevel(k) contourLevel(k)]);
    
    [x{k},y{k},z{k}] = extractSphereContour(C);
   
    cVal = R*[x{k};y{k};z{k}];
    
end


