function c = ItoTaylorCoeffs(model,X_tMinusOne,dt,theta,method)

% 'model' is one of {'sin','cir','toy'}
% 'method' is one of {'milstein_u','scheme3_u','scheme4_t','weakPartial3_u'}
%    where the u or t refers to whether we work with the untransformed 
%    or transformed process.

fh = str2func([ lower(model) , '_', lower(method(end))]);

switch lower(method)
   case 'milstein_u' % this is the same as strong1_u
      [a0,a1,a2,a3,a4,b0,b1,b2,b3,b4] = fh(X_tMinusOne,theta);
      c = [b0 1/2*b0*b1 a0*dt-1/2*b0*b1*dt];
   case 'scheme3_u'
      [a0,a1,a2,a3,a4,b0,b1,b2,b3,b4] = fh(X_tMinusOne,theta);
      c = [b0+dt*(a0*b1+1/2*b0^2*b2),...
         1/2*b0*b1,...
         b0*a1-a0*b1-1/2*b0^2*b2,...
         a0*dt+(a0*a1+1/2*b0^2*a2)*1/2*dt^2-1/2*b0*b1*dt];
   case 'weakpartial3_t'
      [a0,a1,a2,a3,a4] = fh(X_tMinusOne,theta);
      c(4) =  a0*dt + (a0*a1)*1/2*dt^2 + ... 
         (a0*(a0*a2+a1^2+1/2*a3)+1/2*(a0*a3+3*a1*a2)+1/4*a4)*1/6*dt^3;
      c(1:3) = [1 a1+a1^2*dt a0*a2+1/2*a3-a1^2];
   case {'scheme4_t','weakp3gammaj4_t','weakp3gaussj4_t','scheme4_2ndorder_t'}
      [a0,a1,a2,a3,a4] = fh(X_tMinusOne,theta);
      c(5) =  a0*dt + (a0*a1)*1/2*dt^2 + ...
         (a0*(a0*a2+a1^2+1/2*a3)+1/2*(a0*a3+3*a1*a2)+1/4*a4)*1/6*dt^3;
      c(1:4) = [1 a1+a1^2*dt a0*a2+1/2*a3-a1^2 1/2*a2];
   otherwise
      a=1;
end

end

% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4] = bessel_t(x,theta)
kappa = theta; 
[a0, a1, a2, a3, a4] = deal(...
   (kappa - 1)/2*x^(-1),...
   -(kappa - 1)/2*x^(-2),...
   (kappa - 1)*x^(-3),...
   -3*(kappa - 1)*x^(-4),...
   12*(kappa - 1)*x^(-5));
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = bessel_u(x,theta)
kappa = theta; 
[a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = deal(...
   kappa,0,0,0,0,...
   2*x^(1/2),...
   x^(-1/2),...
   -1/2*x^(-3/2),...
   3/4*x^(-5/2),...
   -15/8*x^(-7/2));
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4] = cir_t(x,theta)
kappa = theta(1); alpha = theta(2); beta = theta(3);
foo = 2*kappa*alpha/beta^2-1/2;
[a0, a1, a2, a3, a4] = deal(...
   foo/x - kappa/2*x, ...
   -foo/x^2 - kappa/2, ...
   2*foo/x^3, ...
   -6*foo/x^4, ...
   24*foo/x^5);
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = cir_u(x,theta)
kappa = theta(1); alpha = theta(2); beta = theta(3);
[a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = deal(...
   kappa*(alpha-x), ...
   -kappa, ...
   0, 0, 0, ...
   beta*x^(1/2), ...
   1/2*beta*x^(-1/2), ...
   -1/4*beta*x^(-3/2), ...
   3/8*beta*x^(-5/2), ...
   -15/16*beta*x^(-7/2));
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = ginzland_u(x,theta)
kappa = theta(1); alpha = theta(2); beta = theta(3);
[a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = deal(...
   -kappa*x - alpha*x^3, ...
   -kappa - 3*alpha*x^2, ...
   -6*alpha*x, ...
   -6*alpha, ...
   0,...
   beta,0,0,0,0);
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4] = ginzland_t(x,theta)
kappa = theta(1); alpha = theta(2); beta = theta(3);
[a0, a1, a2, a3, a4] = deal(...
   -kappa*x - alpha*beta^2*x^3, ...
   -kappa - 3*alpha*beta^2*x^2, ...
   -6*alpha*beta^2*x, ...
   -6*alpha*beta^2, ...
   0);
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4] = log_t(x,theta)
kappa = theta(1); alpha = theta(2); beta = theta(3);
[a0, a1, a2, a3, a4] = deal(...
   beta/2 - kappa/beta + kappa/(beta*alpha)*exp(-beta*x), ...
   -kappa/alpha*exp(-beta*x), ...
   beta*kappa/alpha*exp(-beta*x), ...
   -beta^2*kappa/alpha*exp(-beta*x), ...
   beta^3*kappa/alpha*exp(-beta*x));
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4] = ou_t(x,theta)
kappa = theta(1); alpha = theta(2); beta = theta(3);
[a0, a1, a2, a3, a4] = deal(...
   kappa*alpha/beta-kappa*x, ...
   -kappa,0,0,0);
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = ou_u(x,theta)
kappa = theta(1); alpha = theta(2); beta = theta(3);
[a0, a1, a2, a3, a4, b0, b1, b2, b3, b4] = deal(...
   kappa*(alpha-x), ...
   -kappa, ...
   0,0,0, ...
   beta,0,0,0,0);
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4] = sin_t(x,theta)
alpha = theta;
[a0, a1, a2, a3, a4] = deal(...
   sin(x-alpha), ...
   cos(x-alpha), ...
   -sin(x-alpha), ...
   -cos(x-alpha), ...
   sin(x-alpha));
end
% ----------------------------------------------------------------------
function [a0, a1, a2, a3, a4] = toy_t(x,theta)
[a0, a1, a2, a3, a4] = deal(theta,0,0,0,0);
end
