function out = Kscheme4_t(derivNumber,c,T,s,thresholdC2)

if nargin<5, thresholdC2 = 1e-2; end
s_in = s;

out = zeros(size(s));

switch derivNumber
   case 0
      % For any very small values of C2 = 2*c4*s*T^2, use the power-series expansion:
      ind = (2*abs(s*c(4))*T^2<thresholdC2);
      if any(ind)
         s = s_in(ind);
         s_c4_Tsq = s .* c(4) .* T .^ 2;
         out(ind) = 0.248e3 ./ 0.2835e4 .* s .^ 5 .* c(4) .^ 3 .* T .^ 9 .* c(2) .^ 2 + 0.5528e4 ./ 0.155925e6 .* s .^ 5 .* c(4) .^ 3 .* T .^ 11 .* c(3) .^ 2 + s .^ 3 .* c(4) .* T .^ 3 .* c(1) .^ 2 ./ 0.3e1 + 0.7436552e7 ./ 0.638512875e9 .* s .^ 8 .* c(4) .^ 8 .* T .^ 16 + 0.17e2 ./ 0.315e3 .* s .^ 3 .* c(3) .^ 2 .* T .^ 7 .* c(4) + 0.34e2 ./ 0.315e3 .* s .^ 4 .* c(4) .^ 2 .* T .^ 7 .* c(2) .^ 2 + 0.124e3 ./ 0.2835e4 .* s .^ 4 .* c(4) .^ 2 .* T .^ 9 .* c(3) .^ 2 + s .^ 2 .* c(1) .* c(2) .* T .^ 2 ./ 0.2e1 + s .^ 2 .* c(1) .* c(3) .* T .^ 3 ./ 0.3e1 + 0.199360981e9 ./ 0.2724321600e10 .* s .^ 7 .* c(4) .^ 5 .* T .^ 14 .* c(2) .* c(3) + 0.22112e5 ./ 0.155925e6 .* s .^ 6 .* c(4) .^ 4 .* T .^ 11 .* c(1) .* c(3) + 0.50521e5 ./ 0.226800e6 .* s .^ 6 .* c(4) .^ 4 .* T .^ 10 .* c(1) .* c(2) + 0.68e2 ./ 0.315e3 .* s .^ 5 .* c(4) .^ 3 .* T .^ 7 .* c(1) .^ 2 + 0.699008e6 ./ 0.42567525e8 .* s .^ 7 .* c(4) .^ 7 .* T .^ 14 + 0.42159119870227e14 ./ 0.4434977619072000e16 .* s .^ 11 .* c(4) .^ 9 .* T .^ 21 .* c(2) .^ 2 + 0.11056e5 ./ 0.467775e6 .* s .^ 6 .* c(4) .^ 6 .* T .^ 12 + 0.56814228736e11 ./ 0.1856156927625e13 .* s .^ 10 .* c(4) .^ 8 .* T .^ 19 .* c(2) .^ 2 + 0.2417723658752e13 ./ 0.194896477400625e15 .* s .^ 10 .* c(4) .^ 8 .* T .^ 21 .* c(3) .^ 2 + 0.50521e5 ./ 0.453600e6 .* s .^ 5 .* c(4) .^ 3 .* T .^ 10 .* c(2) .* c(3) + 0.68e2 ./ 0.315e3 .* s .^ 4 .* c(4) .^ 2 .* T .^ 7 .* c(1) .* c(3) + 0.61e2 ./ 0.180e3 .* s .^ 4 .* c(4) .^ 2 .* T .^ 6 .* c(1) .* c(2) + 0.14814847529501e14 ./ 0.380140938777600e15 .* s .^ 10 .* c(4) .^ 8 .* T .^ 20 .* c(2) .* c(3) + 0.819786496e9 ./ 0.10854718875e11 .* s .^ 9 .* c(4) .^ 7 .* T .^ 17 .* c(1) .* c(3) + 0.3878302429e10 ./ 0.32691859200e11 .* s .^ 9 .* c(4) .^ 7 .* T .^ 16 .* c(1) .* c(2) + 0.2e1 ./ 0.15e2 .* s .^ 3 .* c(2) .^ 2 .* T .^ 5 .* c(4) + 0.180730578121579e15 ./ 0.195139015239168000e18 .* s .^ 12 .* c(4) .^ 10 .* T .^ 23 .* c(2) .^ 2 + 0.699008e6 ./ 0.6081075e7 .* s .^ 8 .* c(4) .^ 6 .* T .^ 13 .* c(1) .^ 2 + 0.17e2 ./ 0.315e3 .* s .^ 4 .* c(4) .^ 4 .* T .^ 8 + 0.29746208e8 ./ 0.638512875e9 .* s .^ 8 .* c(4) .^ 6 .* T .^ 15 .* c(2) .^ 2 + 0.204946624e9 ./ 0.10854718875e11 .* s .^ 8 .* c(4) .^ 6 .* T .^ 17 .* c(3) .^ 2 + 0.496e3 ./ 0.2835e4 .* s .^ 6 .* c(4) .^ 4 .* T .^ 9 .* c(1) .^ 2 + 0.3878302429e10 ./ 0.65383718400e11 .* s .^ 8 .* c(4) .^ 6 .* T .^ 16 .* c(2) .* c(3) + 0.699008e6 ./ 0.6081075e7 .* s .^ 7 .* c(4) .^ 5 .* T .^ 13 .* c(1) .* c(3) + 0.540553e6 ./ 0.2993760e7 .* s .^ 7 .* c(4) .^ 5 .* T .^ 12 .* c(1) .* c(2) + 0.9734581546601e13 ./ 0.9978699642912000e16 .* s .^ 12 .* c(4) .^ 10 .* T .^ 24 .* c(2) .* c(3) + 0.572300870656e12 ./ 0.64965492466875e14 .* s .^ 11 .* c(4) .^ 9 .* T .^ 21 .* c(1) .* c(3) + 0.5298822473947e13 ./ 0.316784115648000e15 .* s .^ 11 .* c(4) .^ 9 .* T .^ 20 .* c(1) .* c(2) + s .^ 2 .* c(4) .^ 2 .* T .^ 4 ./ 0.6e1 + 0.11056e5 ./ 0.155925e6 .* s .^ 6 .* c(4) .^ 4 .* T .^ 11 .* c(2) .^ 2 + 0.174752e6 ./ 0.6081075e7 .* s .^ 6 .* c(4) .^ 4 .* T .^ 13 .* c(3) .^ 2 + 0.818397979203163e15 ./ 0.73177130714688000e17 .* s .^ 11 .* c(4) .^ 9 .* T .^ 22 .* c(2) .* c(3) + 0.496e3 ./ 0.14175e5 .* s .^ 5 .* c(4) .^ 5 .* T .^ 10 + 0.409893248e9 ./ 0.10854718875e11 .* s .^ 9 .* c(4) .^ 7 .* T .^ 17 .* c(2) .^ 2 + 0.28407114368e11 ./ 0.1856156927625e13 .* s .^ 9 .* c(4) .^ 7 .* T .^ 19 .* c(3) .^ 2 + 0.5e1 ./ 0.24e2 .* s .^ 2 .* c(2) .* T .^ 4 .* c(3) + 0.277e3 ./ 0.2016e4 .* s .^ 4 .* c(4) .^ 2 .* T .^ 8 .* c(2) .* c(3) + 0.61e2 ./ 0.360e3 .* s .^ 3 .* c(2) .* T .^ 6 .* c(4) .* c(3) + 0.4e1 ./ 0.15e2 .* s .^ 3 .* c(1) .* c(4) .* T .^ 5 .* c(3) + 0.5e1 ./ 0.12e2 .* s .^ 3 .* c(1) .* c(4) .* T .^ 4 .* c(2) + 0.59492416e8 ./ 0.638512875e9 .* s .^ 9 .* c(4) .^ 7 .* T .^ 15 .* c(1) .^ 2 + 0.278989256704e12 ./ 0.85754450056275e14 .* s .^ 11 .* c(4) .^ 9 .* T .^ 23 .* c(3) .^ 2 + 0.4e1 ./ 0.15e2 .* s .^ 4 .* c(4) .^ 2 .* T .^ 5 .* c(1) .^ 2 + 0.540553e6 ./ 0.5987520e7 .* s .^ 6 .* c(4) .^ 4 .* T .^ 12 .* c(2) .* c(3) + 0.496e3 ./ 0.2835e4 .* s .^ 5 .* c(4) .^ 3 .* T .^ 9 .* c(1) .* c(3) + ...
            0.277e3 ./ 0.1008e4 .* s .^ 5 .* c(4) .^ 3 .* T .^ 8 .* c(1) .* c(2) + 0.4e1 ./ 0.45e2 .* s .^ 3 .* c(4) .^ 3 .* T .^ 6 + 0.349504e6 ./ 0.6081075e7 .* s .^ 7 .* c(4) .^ 5 .* T .^ 13 .* c(2) .^ 2 + 0.14873104e8 ./ 0.638512875e9 .* s .^ 7 .* c(4) .^ 5 .* T .^ 15 .* c(3) .^ 2 + 0.113628457472e12 ./ 0.1856156927625e13 .* s .^ 10 .* c(4) .^ 8 .* T .^ 19 .* c(1) .* c(3) + 0.2404879675441e13 ./ 0.25009272288000e14 .* s .^ 10 .* c(4) .^ 8 .* T .^ 18 .* c(1) .* c(2) + 0.3758707049614336e16 ./ 0.14631853040851921875e20 .* s .^ 12 .* c(4) .^ 10 .* T .^ 25 .* c(3) .^ 2 + 0.819786496e9 ./ 0.10854718875e11 .* s .^ 10 .* c(4) .^ 8 .* T .^ 17 .* c(1) .^ 2 + s_c4_Tsq ./ 0.2e1 + 0.2404879675441e13 ./ 0.50018544576000e14 .* s .^ 9 .* c(4) .^ 7 .* T .^ 18 .* c(2) .* c(3) + 0.59492416e8 ./ 0.638512875e9 .* s .^ 8 .* c(4) .^ 6 .* T .^ 15 .* c(1) .* c(3) + 0.199360981e9 ./ 0.1362160800e10 .* s .^ 8 .* c(4) .^ 6 .* T .^ 14 .* c(1) .* c(2) + 0.22112e5 ./ 0.155925e6 .* s .^ 7 .* c(4) .^ 5 .* T .^ 11 .* c(1) .^ 2 + s .^ 2 .* c(3) .^ 2 .* T .^ 5 ./ 0.15e2 + T .* s .^ 2 .* c(1) .^ 2 ./ 0.2e1 + s .^ 2 .* c(2) .^ 2 .* T .^ 3 ./ 0.6e1;
      end
      % For all others use the non-power-series expression:
      if any(~ind)
         s = s_in(~ind);
         s_c4_Tsq = s.*c(4).*T.^2;
         out(~ind) = -log((-2*s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) ./ 0.2e1) ./ 0.2e1 - sqrt(-2*s_c4_Tsq) ./ 0.2e1 - log(0.1e1 - exp(-0.2e1 .* sqrt(-2*s_c4_Tsq))) ./ 0.2e1 + log(sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1))) ./ 0.2e1 + (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .^ 2 .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + s .^ 2 .* c(3) .^ 2 .* T .^ 5 .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2) + (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s_c4_Tsq .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2)) .^ 2 .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1)) ./ 0.2e1;
      end
      out = real(out);
   case 1
      % For any very small values of C2 = 2*c4*s*T^2, use the power-series
      % expansion:
      ind = (2*abs(s*c(4))*T^2<thresholdC2);
      if any(ind)
         s = s_in(ind);
         s_c4_Tsq = s .* c(4) .* T .^ 2;
         out(ind) = c(4) .* T .^ 2 ./ 0.2e1 + 0.5e1 ./ 0.12e2 .* s .* c(2) .* T .^ 4 .* c(3) + 0.2e1 ./ 0.5e1 .* s .^ 2 .* c(2) .^ 2 .* T .^ 5 .* c(4) + 0.17e2 ./ 0.105e3 .* s .^ 2 .* c(3) .^ 2 .* T .^ 7 .* c(4) + 0.136e3 ./ 0.315e3 .* s .^ 3 .* c(4) .^ 2 .* T .^ 7 .* c(2) .^ 2 + 0.496e3 ./ 0.2835e4 .* s .^ 3 .* c(4) .^ 2 .* T .^ 9 .* c(3) .^ 2 + s .* c(1) .* c(2) .* T .^ 2 + 0.2e1 ./ 0.3e1 .* s .* c(1) .* c(3) .* T .^ 3 + 0.113628457472e12 ./ 0.371231385525e12 .* s .^ 9 .* c(4) .^ 8 .* T .^ 19 .* c(2) .^ 2 + 0.4835447317504e13 ./ 0.38979295480125e14 .* s .^ 9 .* c(4) .^ 8 .* T .^ 21 .* c(3) .^ 2 + 0.5592064e7 ./ 0.6081075e7 .* s .^ 7 .* c(4) .^ 6 .* T .^ 13 .* c(1) .^ 2 + 0.44224e5 ./ 0.51975e5 .* s .^ 5 .* c(4) .^ 4 .* T .^ 11 .* c(1) .* c(3) + 0.199360981e9 ./ 0.389188800e9 .* s .^ 6 .* c(4) .^ 5 .* T .^ 14 .* c(2) .* c(3) + 0.50521e5 ./ 0.37800e5 .* s .^ 5 .* c(4) .^ 4 .* T .^ 10 .* c(1) .* c(2) + 0.2e1 ./ 0.15e2 .* s .* c(3) .^ 2 .* T .^ 5 + T .* s .* c(1) .^ 2 + s .* c(2) .^ 2 .* T .^ 3 ./ 0.3e1 + 0.272e3 ./ 0.315e3 .* s .^ 3 .* c(4) .^ 2 .* T .^ 7 .* c(1) .* c(3) + 0.50521e5 ./ 0.90720e5 .* s .^ 4 .* c(4) .^ 3 .* T .^ 10 .* c(2) .* c(3) + 0.61e2 ./ 0.45e2 .* s .^ 3 .* c(4) .^ 2 .* T .^ 6 .* c(1) .* c(2) + 0.22112e5 ./ 0.51975e5 .* s .^ 5 .* c(4) .^ 4 .* T .^ 11 .* c(2) .^ 2 + 0.349504e6 ./ 0.2027025e7 .* s .^ 5 .* c(4) .^ 4 .* T .^ 13 .* c(3) .^ 2 + 0.16e2 ./ 0.15e2 .* s .^ 3 .* c(4) .^ 2 .* T .^ 5 .* c(1) .^ 2 + s .* c(4) .^ 2 .* T .^ 4 ./ 0.3e1 + 0.349504e6 ./ 0.868725e6 .* s .^ 6 .* c(4) .^ 5 .* T .^ 13 .* c(2) .^ 2 + 0.14873104e8 ./ 0.91216125e8 .* s .^ 6 .* c(4) .^ 5 .* T .^ 15 .* c(3) .^ 2 + 0.68e2 ./ 0.63e2 .* s .^ 4 .* c(4) .^ 3 .* T .^ 7 .* c(1) .^ 2 + 0.4e1 ./ 0.15e2 .* s .^ 2 .* c(4) .^ 3 .* T .^ 6 + 0.59492416e8 ./ 0.638512875e9 .* s .^ 7 .* c(4) .^ 8 .* T .^ 16 + 0.475939328e9 ./ 0.638512875e9 .* s .^ 7 .* c(4) .^ 6 .* T .^ 15 .* c(1) .* c(3) + 0.2404879675441e13 ./ 0.5557616064000e13 .* s .^ 8 .* c(4) .^ 7 .* T .^ 18 .* c(2) .* c(3) + 0.199360981e9 ./ 0.170270100e9 .* s .^ 7 .* c(4) .^ 6 .* T .^ 14 .* c(1) .* c(2) + 0.248e3 ./ 0.567e3 .* s .^ 4 .* c(4) .^ 3 .* T .^ 9 .* c(2) .^ 2 + 0.5528e4 ./ 0.31185e5 .* s .^ 4 .* c(4) .^ 3 .* T .^ 11 .* c(3) .^ 2 + s .^ 2 .* c(4) .* T .^ 3 .* c(1) .^ 2 + 0.699008e6 ./ 0.868725e6 .* s .^ 6 .* c(4) .^ 5 .* T .^ 13 .* c(1) .* c(3) + 0.3878302429e10 ./ 0.8172964800e10 .* s .^ 7 .* c(4) .^ 6 .* T .^ 16 .* c(2) .* c(3) + 0.540553e6 ./ 0.427680e6 .* s .^ 6 .* c(4) .^ 5 .* T .^ 12 .* c(1) .* c(2) + 0.42159119870227e14 ./ 0.403179783552000e15 .* s .^ 10 .* c(4) .^ 9 .* T .^ 21 .* c(2) .^ 2 + 0.278989256704e12 ./ 0.7795859096025e13 .* s .^ 10 .* c(4) .^ 9 .* T .^ 23 .* c(3) .^ 2 + 0.59492416e8 ./ 0.70945875e8 .* s .^ 8 .* c(4) .^ 7 .* T .^ 15 .* c(1) .^ 2 + 0.699008e6 ./ 0.6081075e7 .* s .^ 6 .* c(4) .^ 7 .* T .^ 14 + 0.227256914944e12 ./ 0.371231385525e12 .* s .^ 9 .* c(4) .^ 8 .* T .^ 19 .* c(1) .* c(3) + 0.818397979203163e15 ./ 0.6652466428608000e16 .* s .^ 10 .* c(4) .^ 9 .* T .^ 22 .* c(2) .* c(3) + 0.2404879675441e13 ./ 0.2500927228800e13 .* s .^ 9 .* c(4) .^ 8 .* T .^ 18 .* c(1) .* c(2) + 0.1639572992e10 ./ 0.2170943775e10 .* s .^ 9 .* c(4) .^ 8 .* T .^ 17 .* c(1) .^ 2 + 0.15034828198457344e17 ./ 0.4877284346950640625e19 .* s .^ 11 .* c(4) .^ 10 .* T .^ 25 .* c(3) .^ 2 + 0.496e3 ./ 0.2835e4 .* s .^ 4 .* c(4) .^ 5 .* T .^ 10 + 0.4e1 ./ 0.5e1 .* s .^ 2 .* c(1) .* c(4) .* T .^ 5 .* c(3) + 0.61e2 ./ 0.120e3 .* s .^ 2 .* c(2) .* T .^ 6 .* c(4) .* c(3) + 0.277e3 ./ 0.504e3 .* s .^ 3 .* c(4) .^ 2 .* T .^ 8 .* c(2) .* c(3) + 0.5e1 ./ 0.4e1 .* s .^ 2 .* c(1) .* c(4) .* T .^ 4 .* c(2) + 0.496e3 ./ 0.567e3 .* s .^ 4 .* c(4) .^ 3 .* T .^ 9 .* c(1) .* c(3) + 0.540553e6 ./ 0.997920e6 .* s .^ 5 .* c(4) .^ 4 .* T .^ 12 .* c(2) .* c(3) + 0.1385e4 ./ 0.1008e4 .* s .^ 4 .* c(4) .^ 3 .* T .^ 8 .* c(1) .* c(2) + 0.237969664e9 ./ 0.638512875e9 .* s .^ 7 .* c(4) .^ 6 .* T .^ 15 .* c(2) .^ 2 + 0.1639572992e10 ./ 0.10854718875e11 .* s .^ 7 .* c(4) .^ 6 .* T .^ 17 .* c(3) .^ 2 + 0.992e3 ./ 0.945e3 ... 
            .* s .^ 5 .* c(4) .^ 4 .* T .^ 9 .* c(1) .^ 2 + 0.68e2 ./ 0.315e3 .* s .^ 3 .* c(4) .^ 4 .* T .^ 8 + 0.409893248e9 ./ 0.1206079875e10 .* s .^ 8 .* c(4) .^ 7 .* T .^ 17 .* c(2) .^ 2 + 0.28407114368e11 ./ 0.206239658625e12 .* s .^ 8 .* c(4) .^ 7 .* T .^ 19 .* c(3) .^ 2 + 0.22112e5 ./ 0.22275e5 .* s .^ 6 .* c(4) .^ 5 .* T .^ 11 .* c(1) .^ 2 + 0.180730578121579e15 ./ 0.16261584603264000e17 .* s .^ 11 .* c(4) .^ 10 .* T .^ 23 .* c(2) .^ 2 + 0.572300870656e12 ./ 0.5905953860625e13 .* s .^ 10 .* c(4) .^ 9 .* T .^ 21 .* c(1) .* c(3) + 0.9734581546601e13 ./ 0.831558303576000e15 .* s .^ 11 .* c(4) .^ 10 .* T .^ 24 .* c(2) .* c(3) + 0.5298822473947e13 ./ 0.28798555968000e14 .* s .^ 10 .* c(4) .^ 9 .* T .^ 20 .* c(1) .* c(2) + 0.819786496e9 ./ 0.1206079875e10 .* s .^ 8 .* c(4) .^ 7 .* T .^ 17 .* c(1) .* c(3) + 0.14814847529501e14 ./ 0.38014093877760e14 .* s .^ 9 .* c(4) .^ 8 .* T .^ 20 .* c(2) .* c(3) + 0.3878302429e10 ./ 0.3632428800e10 .* s .^ 8 .* c(4) .^ 7 .* T .^ 16 .* c(1) .* c(2) + 0.22112e5 ./ 0.155925e6 .* s .^ 5 .* c(4) .^ 6 .* T .^ 12;
      end
      % For all others use the non-power-series expression:
      if any(~ind)
         s = s_in(~ind);
         s_c4_Tsq = s.*c(4).*T.^2;
         coty = cot(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1);
         out(~ind) = 0.1e1 ./ s ./ 0.4e1 - cos(sqrt(0.2e1) .* sqrt(s_c4_Tsq)) .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ sin(sqrt(0.2e1) .* sqrt(s_c4_Tsq)) ./ 0.4e1 + (-sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) ./ (coty - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1)) .* c(4) .* T .^ 2 ./ 0.2e1 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) ./ (coty - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1)) .^ 2 .* ((-0.1e1 - coty .^ 2) .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1)) .* sqrt(0.2e1) .* sqrt(s_c4_Tsq) .* (coty - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1)) ./ 0.4e1 + 0.2e1 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) + (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .^ 2 .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.2e1 .* s .* c(3) .^ 2 .* T .^ 5 .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* coty ./ 0.16e2) + s .^ 2 .* c(3) .^ 2 .* T .^ 5 .* (-0.1e1 ./ s .^ 3 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.4e1 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.48e2 + 0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.5e1 ./ 0.2e1) .* coty .* c(4) .* T .^ 2 - 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (-0.1e1 - coty .^ 2) ./ 0.32e2) + (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s_c4_Tsq .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* coty ./ 0.16e2)) .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) ./ (coty - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1)) .* (c(1) .* sqrt(T) + c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s_c4_Tsq .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s_c4_Tsq .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ... 
            ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.8e1 .* s .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* coty ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (-0.1e1 ./ s .^ 3 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.4e1 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.48e2 + 0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.5e1 ./ 0.2e1) .* coty .* c(4) .* T .^ 2 - 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (-0.1e1 - coty .^ 2) ./ 0.32e2)) - (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s_c4_Tsq .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* coty ./ 0.16e2)) .^ 2 .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) ./ (coty - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1)) .* c(4) .* T .^ 2 ./ 0.4e1 - (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s_c4_Tsq .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.3e1 ./ 0.2e1) .* coty ./ 0.16e2)) .^ 2 .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) ./ (coty - tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1)) .^ 2 .* ((-0.1e1 - coty .^ 2) .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s_c4_Tsq) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s_c4_Tsq) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1) ./ 0.2e1;
      end
      out = real(out);
   case 2
      % For any very small values of C2 = 2*c4*s*T^2, use the power-series
      % expansion:
      ind = (2*abs(s*c(4))*T^2<thresholdC2);
      if any(ind)
         s = s_in(ind);
         s_c4_Tsq = s .* c(4) .* T .^ 2;
         out(ind) = 0.8e1 ./ 0.15e2 .* s .* c(4) .^ 3 .* T .^ 6 + 0.349504e6 ./ 0.405405e6 .* s .^ 4 .* c(4) .^ 4 .* T .^ 13 .* c(3) .^ 2 + 0.699008e6 ./ 0.289575e6 .* s .^ 5 .* c(4) .^ 5 .* T .^ 13 .* c(2) .^ 2 + 0.29746208e8 ./ 0.30405375e8 .* s .^ 5 .* c(4) .^ 5 .* T .^ 15 .* c(3) .^ 2 + 0.22112e5 ./ 0.10395e5 .* s .^ 4 .* c(4) .^ 4 .* T .^ 11 .* c(2) .^ 2 + 0.22112e5 ./ 0.31185e5 .* s .^ 3 .* c(4) .^ 3 .* T .^ 11 .* c(3) .^ 2 + 0.272e3 ./ 0.63e2 .* s .^ 3 .* c(4) .^ 3 .* T .^ 7 .* c(1) .^ 2 + 0.992e3 ./ 0.567e3 .* s .^ 3 .* c(4) .^ 3 .* T .^ 9 .* c(2) .^ 2 + 0.16e2 ./ 0.5e1 .* s .^ 2 .* c(4) .^ 2 .* T .^ 5 .* c(1) .^ 2 + c(1) .* c(2) .* T .^ 2 + 0.2404879675441e13 ./ 0.694702008000e12 .* s .^ 7 .* c(4) .^ 7 .* T .^ 18 .* c(2) .* c(3) + 0.2e1 .* c(4) .* T .^ 3 .* s .* c(1) .^ 2 + 0.1385e4 ./ 0.252e3 .* s .^ 3 .* c(4) .^ 3 .* T .^ 8 .* c(1) .* c(2) + 0.1984e4 ./ 0.567e3 .* s .^ 3 .* c(4) .^ 3 .* T .^ 9 .* c(1) .* c(3) + 0.50521e5 ./ 0.22680e5 .* s .^ 3 .* c(4) .^ 3 .* T .^ 10 .* c(2) .* c(3) + 0.199360981e9 ./ 0.64864800e8 .* s .^ 5 .* c(4) .^ 5 .* T .^ 14 .* c(2) .* c(3) + 0.3878302429e10 ./ 0.1167566400e10 .* s .^ 6 .* c(4) .^ 6 .* T .^ 16 .* c(2) .* c(3) + 0.475939328e9 ./ 0.91216125e8 .* s .^ 6 .* c(4) .^ 6 .* T .^ 15 .* c(1) .* c(3) + 0.199360981e9 ./ 0.24324300e8 .* s .^ 6 .* c(4) .^ 6 .* T .^ 14 .* c(1) .* c(2) + 0.1639572992e10 ./ 0.1550674125e10 .* s .^ 6 .* c(4) .^ 6 .* T .^ 17 .* c(3) .^ 2 + 0.2e1 ./ 0.15e2 .* c(3) .^ 2 .* T .^ 5 + c(2) .^ 2 .* T .^ 3 ./ 0.3e1 + 0.540553e6 ./ 0.199584e6 .* s .^ 4 .* c(4) .^ 4 .* T .^ 12 .* c(2) .* c(3) + 0.44224e5 ./ 0.10395e5 .* s .^ 4 .* c(4) .^ 4 .* T .^ 11 .* c(1) .* c(3) + 0.50521e5 ./ 0.7560e4 .* s .^ 4 .* c(4) .^ 4 .* T .^ 10 .* c(1) .* c(2) + 0.6558291968e10 ./ 0.1206079875e10 .* s .^ 7 .* c(4) .^ 7 .* T .^ 17 .* c(1) .* c(3) + 0.3878302429e10 ./ 0.454053600e9 .* s .^ 7 .* c(4) .^ 7 .* T .^ 16 .* c(1) .* c(2) + 0.5592064e7 ./ 0.868725e6 .* s .^ 6 .* c(4) .^ 6 .* T .^ 13 .* c(1) .^ 2 + 0.1398016e7 ./ 0.289575e6 .* s .^ 5 .* c(4) .^ 5 .* T .^ 13 .* c(1) .* c(3) + 0.540553e6 ./ 0.71280e5 .* s .^ 5 .* c(4) .^ 5 .* T .^ 12 .* c(1) .* c(2) + 0.68e2 ./ 0.105e3 .* s .^ 2 .* c(4) .^ 4 .* T .^ 8 + c(4) .^ 2 .* T .^ 4 ./ 0.3e1 + 0.5e1 ./ 0.12e2 .* c(2) .* T .^ 4 .* c(3) + 0.277e3 ./ 0.168e3 .* s .^ 2 .* c(4) .^ 2 .* T .^ 8 .* c(2) .* c(3) + 0.61e2 ./ 0.60e2 .* s .* c(2) .* T .^ 6 .* c(4) .* c(3) + 0.8e1 ./ 0.5e1 .* s .* c(1) .* c(4) .* T .^ 5 .* c(3) + 0.5e1 ./ 0.2e1 .* s .* c(1) .* c(4) .* T .^ 4 .* c(2) + 0.2e1 ./ 0.3e1 .* c(1) .* c(3) .* T .^ 3 + 0.4835447317504e13 ./ 0.4331032831125e13 .* s .^ 8 .* c(4) .^ 8 .* T .^ 21 .* c(3) .^ 2 + 0.496e3 ./ 0.945e3 .* s .^ 2 .* c(4) .^ 2 .* T .^ 9 .* c(3) .^ 2 + 0.180730578121579e15 ./ 0.1478325873024000e16 .* s .^ 10 .* c(4) .^ 10 .* T .^ 23 .* c(2) .^ 2 + 0.15034828198457344e17 ./ 0.443389486086421875e18 .* s .^ 10 .* c(4) .^ 10 .* T .^ 25 .* c(3) .^ 2 + 0.1639572992e10 ./ 0.241215975e9 .* s .^ 8 .* c(4) .^ 8 .* T .^ 17 .* c(1) .^ 2 + 0.113628457472e12 ./ 0.41247931725e11 .* s .^ 8 .* c(4) .^ 8 .* T .^ 19 .* c(2) .^ 2 + 0.272e3 ./ 0.105e3 .* c(4) .^ 2 .* T .^ 7 .* s .^ 2 .* c(1) .* c(3) + 0.9734581546601e13 ./ 0.75596209416000e14 .* s .^ 10 .* c(4) .^ 10 .* T .^ 24 .* c(2) .* c(3) + 0.818397979203163e15 ./ 0.665246642860800e15 .* s .^ 9 .* c(4) .^ 9 .* T .^ 22 .* c(2) .* c(3) + 0.1144601741312e13 ./ 0.1181190772125e13 .* s .^ 9 .* c(4) .^ 9 .* T .^ 21 .* c(1) .* c(3) + 0.5298822473947e13 ./ 0.2879855596800e13 .* s .^ 9 .* c(4) .^ 9 .* T .^ 20 .* c(1) .* c(2) + 0.1398016e7 ./ 0.2027025e7 .* s .^ 5 .* c(4) .^ 7 .* T .^ 14 + 0.475939328e9 ./ 0.70945875e8 .* s .^ 7 .* c(4) .^ 7 .* T .^ 15 .* c(1) .^ 2 + 0.61e2 ./ 0.15e2 .* c(4) .^ 2 .* T .^ 6 .* s .^ 2 .* c(1) .* c(2) + 0.34e2 ./ 0.105e3 .* s .* c(3) .^ 2 .* T .^ 7 .* c(4) + 0.136e3 ./ 0.105e3 .* s .^ 2 .* c(4) .^ 2 .* T .^ 7 .* c(2) .^ 2 + T .* c(1) .^ 2 + 0.14814847529501e14 ./ 0.4223788208640e13 .* s .^ 8 .* c(4) .^ 8 .* T .^ 20 .* c(2) .* c(3) + 0.42159119870227e14 ./ 0.40317978355200e14 ...
            .* s .^ 9 .* c(4) .^ 9 .* T .^ 21 .* c(2) .^ 2 + 0.557978513408e12 ./ 0.1559171819205e13 .* s .^ 9 .* c(4) .^ 9 .* T .^ 23 .* c(3) .^ 2 + 0.227256914944e12 ./ 0.41247931725e11 .* s .^ 8 .* c(4) .^ 8 .* T .^ 19 .* c(1) .* c(3) + 0.2404879675441e13 ./ 0.277880803200e12 .* s .^ 8 .* c(4) .^ 8 .* T .^ 18 .* c(1) .* c(2) + 0.1984e4 ./ 0.2835e4 .* s .^ 3 .* c(4) .^ 5 .* T .^ 10 + 0.227256914944e12 ./ 0.206239658625e12 .* s .^ 7 .* c(4) .^ 7 .* T .^ 19 .* c(3) .^ 2 + 0.3279145984e10 ./ 0.1206079875e10 .* s .^ 7 .* c(4) .^ 7 .* T .^ 17 .* c(2) .^ 2 + 0.992e3 ./ 0.189e3 .* s .^ 4 .* c(4) .^ 4 .* T .^ 9 .* c(1) .^ 2 + 0.22112e5 ./ 0.31185e5 .* s .^ 4 .* c(4) .^ 6 .* T .^ 12 + 0.237969664e9 ./ 0.91216125e8 .* s .^ 6 .* c(4) .^ 6 .* T .^ 15 .* c(2) .^ 2 + 0.44224e5 ./ 0.7425e4 .* s .^ 5 .* c(4) .^ 5 .* T .^ 11 .* c(1) .^ 2 + 0.59492416e8 ./ 0.91216125e8 .* s .^ 6 .* c(4) .^ 8 .* T .^ 16 + 0.4e1 ./ 0.5e1 .* s .* c(2) .^ 2 .* T .^ 5 .* c(4);
      end
      % For all others use the non-power-series expression:
      if any(~ind)
         s = s_in(~ind);
         s_c4_Tsq = s.*c(4).*T.^2;
         out(~ind) = (-sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .* c(4) .* T .^ 2 ./ 0.2e1 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 2 .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1)) .* sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1) ./ 0.4e1 + (0.3e1 ./ 0.4e1 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .* c(4) .^ 2 .* T .^ 4 + sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 2 .* c(4) .* T .^ 2 .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1) + 0.2e1 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 3 .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1) .^ 2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 2 .* (-cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ s .* c(4) .* T .^ 2 ./ 0.4e1 - (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 ./ 0.8e1 - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ s .* c(4) .* T .^ 2 ./ 0.4e1 + (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 ./ 0.8e1)) .* sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) .* (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) ./ 0.4e1 + 0.4e1 .* s .* c(3) .^ 2 .* T .^ 5 .* (-0.1e1 ./ s .^ 3 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.4e1 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.48e2 + 0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 - 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2) + 0.2e1 .* c(3) .^ 2 .* T .^ 5 .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) ...
            .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2) + s .^ 2 .* c(3) .^ 2 .* T .^ 5 .* (0.3e1 ./ 0.4e1 ./ s .^ 4 ./ c(4) .^ 2 ./ T .^ 4 - 0.1e1 ./ s .^ 3 ./ c(4) ./ T .^ 2 ./ 0.24e2 - 0.15e2 ./ 0.64e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.7e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 + 0.7e1 ./ 0.64e2 ./ s .^ 3 ./ c(4) ./ T .^ 2 .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) + 0.1e1 ./ s .^ 2 .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ 0.64e2) - 0.1e1 ./ s .^ 2 ./ 0.4e1 + (-0.2e1 .* s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 ./ 0.2e1 + 0.4e1 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.16e2) .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) + 0.2e1 .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) .^ 2 .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + (c(1) .* sqrt(T) + c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.8e1 .* s .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (-0.1e1 ./ s .^ 3 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.4e1 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.48e2 + 0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 - 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2)) .^ 2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) - 0.2e1 .* (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) ...
            + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2)) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 2 .* (c(1) .* sqrt(T) + c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.8e1 .* s .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (-0.1e1 ./ s .^ 3 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.4e1 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.48e2 + 0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 - 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2)) .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1) + (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2)) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .* (0.8e1 .* c(4) .* T .^ 2 .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.8e1 .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* ...
            sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.8e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (0.15e2 ./ 0.64e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.7e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 - 0.7e1 ./ 0.64e2 ./ s .^ 3 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) + 0.1e1 ./ s .^ 2 .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ 0.64e2 - 0.1e1 ./ s .^ 3 ./ c(4) ./ T .^ 2 ./ 0.8e1) + 0.8e1 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2) + 0.16e2 .* s .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (-0.1e1 ./ s .^ 3 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.4e1 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.48e2 + 0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 - 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.3e1 ./ 0.4e1 ./ s .^ 4 ./ c(4) .^ 2 ./ T .^ 4 - 0.1e1 ./ s .^ 3 ./ c(4) ./ T .^ 2 ./ 0.24e2 - 0.15e2 ./ 0.64e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.7e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 + 0.7e1 ./ 0.64e2 ./ s .^ 3 ./ c(4) ./ T .^ 2 .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) + 0.1e1 ./ s .^ 2 .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ 0.64e2)) + (-0.2e1 .* s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 .* exp(-0.2e1 .* sqrt(-0.2e1 .* s .* c(4) .* T .^ 2)) ./ (0.1e1 - exp(-0.2e1 .* sqrt(-0.2e1 .* s .* c(4) .* T .^ 2))) + (-sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .* c(4) .* T .^ 2 ./ 0.2e1 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 2 .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1)) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .* c(4) .* T .^ 2 ./ 0.8e1 + (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .^ 2 .* (0.15e2 ./ 0.64e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.7e1 ./ 0.2e1) ...
            .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 - 0.7e1 ./ 0.64e2 ./ s .^ 3 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) + 0.1e1 ./ s .^ 2 .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ 0.64e2 - 0.1e1 ./ s .^ 3 ./ c(4) ./ T .^ 2 ./ 0.8e1) - 0.1e1 ./ s .* c(4) .* T .^ 2 .* exp(-0.2e1 .* sqrt(-0.2e1 .* s .* c(4) .* T .^ 2)) ./ (0.1e1 - exp(-0.2e1 .* sqrt(-0.2e1 .* s .* c(4) .* T .^ 2))) - 0.1e1 ./ s .* c(4) .* T .^ 2 .* exp(-0.2e1 .* sqrt(-0.2e1 .* s .* c(4) .* T .^ 2)) .^ 2 ./ (0.1e1 - exp(-0.2e1 .* sqrt(-0.2e1 .* s .* c(4) .* T .^ 2))) .^ 2 - (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2)) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .* (c(1) .* sqrt(T) + c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (-0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.8e1 .* s .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (-0.1e1 ./ s .^ 3 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.4e1 + 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 ./ 0.48e2 + 0.3e1 ./ 0.32e2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* c(4) .* T .^ 2 - 0.1e1 ./ s .^ 2 ./ c(4) ./ T .^ 2 .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ 0.32e2)) .* c(4) .* T .^ 2 + (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) ...
            .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2)) .^ 2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 2 .* c(4) .* T .^ 2 .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1) ./ 0.2e1 + 0.3e1 ./ 0.8e1 .* (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2)) .^ 2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.5e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .* c(4) .^ 2 .* T .^ 4 + (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2)) .^ 2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 3 .* ((-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1 - (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) .* c(4) .* T .^ 2 ./ 0.4e1) .^ 2 - (s .* c(1) .* sqrt(T) + s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) ./ 0.2e1 + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1) ./ 0.3e1 + 0.4e1 .* s .* c(4) .* T .^ 2 .* (0.2e1 .* s .* c(2) .* T .^ (0.3e1 ./ 0.2e1) + s .* c(3) .* T .^ (0.5e1 ./ 0.2e1)) .* (sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.16e2) + 0.4e1 .* s .^ 2 .* c(3) .* c(4) .* T .^ (0.9e1 ./ 0.2e1) .* (0.1e1 ./ s .^ 2 ./ c(4) .^ 2 ./ T .^ 4 ./ 0.8e1 - 0.1e1 ./ s ./ c(4) ./ T .^ 2 ./ 0.48e2 - sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) ./ 0.16e2)) .^ 2 .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.1e1 ./ 0.2e1) ./ (cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1)) .^ 2 .* (-cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ s .* c(4) .* T .^ 2 ./ 0.4e1 - (-0.1e1 - cot(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* ...
            sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 ./ 0.8e1 - tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .* (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) ./ s .* c(4) .* T .^ 2 ./ 0.4e1 + (0.1e1 + tan(sqrt(0.2e1) .* sqrt(s .* c(4) .* T .^ 2) ./ 0.2e1) .^ 2) .* sqrt(0.2e1) .* (s .* c(4) .* T .^ 2) .^ (-0.3e1 ./ 0.2e1) .* c(4) .^ 2 .* T .^ 4 ./ 0.8e1) ./ 0.2e1;
      end
      out = real(out);
end


