% A demo showing calcuation of an approximation transition density using
% the saddlepoint approach described by Preston and Wood, 2009.

% define model and parameters
model = 'CIR';
theta = [.5 .06 .15];
x0 = 0.1;
dt = 1/12;

% specify the domain
x = linspace(.05,.15,100);

% calculate various estimates of the transition density, together with
% the exact transition density
pEuler = densityTrunc(model,x,x0,dt,theta,'euler_u');
pWeak2 = densitySP(model,x,x0,dt,theta,'scheme3_u');
pWeak3 = densitySP(model,x,x0,dt,theta,'scheme4_t');
pExact = densityExact(model,x,x0,dt,theta);

% plot the densities
plot(...
    x,pWeak2,...
    x,pWeak3,...
    x,pExact,...
    x,pEuler);
xlabel('x');
ylabel('density');
legend({'scheme3','scheme4','exact','euler'});
title([model ' model with x0 = ' num2str(x0) ', dt = ' num2str(dt) ', and theta = ' num2str(theta)]);