function [p,x,c] = densityAS(model,x,x0,dt,theta,order)

% DENSITYAS  Estimate the transition density for an SDE using the
%    Hermite expansion method described in [1].  
%
% Example:
%    f = densityAS('CIR',linspace(.05,.15,100),0.1,1/12,[.5 .06 .15],2);
%
% References:
%   [1] At-Sahalia, Y. (1999) Transition densities for interest rate and 
%       other nonlinear diffusions, Journal of Finance.

% Written by Simon Preston (http://www.maths.nott.ac.uk/~spp), 2009

switch lower(model)
   case 'ou'
      kappa = theta(1);
      alpha = theta(2);
      beta = theta(3);
      p0 = dt .^ (-0.1e1 ./ 0.2e1) .* sqrt(0.2e1) .* pi .^ (-0.1e1 ./ 0.2e1) .* exp(-(x ./ beta - x0 ./ beta) .^ 2 ./ dt ./ 0.2e1) .* exp(kappa .* alpha ./ beta .* (x ./ beta - x0 ./ beta) - kappa .* (x .^ 2 ./ beta .^ 2 - x0 .^ 2 ./ beta .^ 2) ./ 0.2e1) ./ 0.2e1;
      if order>0, c(1,:) = -((kappa .* x0 .^ 2 - 3 .* kappa .* alpha .* x0 + x0 .* kappa .* x + 3 .* kappa .* alpha .^ 2 - 3 .* beta .^ 2 - 3 .* x .* kappa .* alpha + kappa .* x .^ 2) .* kappa ./ beta .^ 2) ./ 0.6e1;
         if order>1, c(2,:) = ((kappa .^ 2 .* x .^ 4 - 6 .* x .^ 3 .* kappa .^ 2 .* alpha + 2 .* x .^ 3 .* kappa .^ 2 .* x0 - 6 .* x .^ 2 .* beta .^ 2 .* kappa + 15 .* x .^ 2 .* kappa .^ 2 .* alpha .^ 2 - 12 .* x .^ 2 .* kappa .^ 2 .* alpha .* x0 + 3 .* x .^ 2 .* kappa .^ 2 .* x0 .^ 2 - 18 .* x .* kappa .^ 2 .* alpha .^ 3 + 2 .* x .* kappa .^ 2 .* x0 .^ 3 + 18 .* x .* beta .^ 2 .* kappa .* alpha + 24 .* x .* kappa .^ 2 .* alpha .^ 2 .* x0 - 6 .* x .* beta .^ 2 .* kappa .* x0 - 12 .* x .* kappa .^ 2 .* alpha .* x0 .^ 2 + 9 .* kappa .^ 2 .* alpha .^ 4 + 15 .* kappa .^ 2 .* alpha .^ 2 .* x0 .^ 2 + 3 .* beta .^ 4 - 18 .* kappa .* alpha .^ 2 .* beta .^ 2 - 6 .* kappa .^ 2 .* alpha .* x0 .^ 3 + kappa .^ 2 .* x0 .^ 4 - 18 .* kappa .^ 2 .* alpha .^ 3 .* x0 + 18 .* beta .^ 2 .* kappa .* alpha .* x0 - 6 .* beta .^ 2 .* kappa .* x0 .^ 2) .* kappa .^ 2 ./ beta .^ 4) ./ 0.36e2;
            if order>2, c(3,:) = -((5 .* kappa .^ 3 .* x0 .^ 6 - 27 .* x .^ 2 .* beta .^ 4 .* kappa - 27 .* beta .^ 4 .* kappa .* x0 .^ 2 - 45 .* beta .^ 2 .* kappa .^ 2 .* x0 .^ 4 + 135 .* kappa .^ 3 .* alpha .^ 6 - 135 .* kappa .* alpha .^ 2 .* beta .^ 4 - 405 .* kappa .^ 2 .* alpha .^ 4 .* beta .^ 2 + 135 .* beta .^ 6 - 45 .* x .^ 4 .* beta .^ 2 .* kappa .^ 2 + 5 .* kappa .^ 3 .* x .^ 6 + 270 .* beta .^ 2 .* kappa .^ 2 .* alpha .* x0 .^ 3 + 135 .* beta .^ 4 .* kappa .* alpha .* x0 - 1080 .* x .* beta .^ 2 .* kappa .^ 2 .* alpha .^ 2 .* x0 + 945 .* x .* kappa .^ 3 .* alpha .^ 4 .* x0 + 495 .* x .* kappa .^ 3 .* alpha .^ 2 .* x0 .^ 3 - 135 .* x .* kappa .^ 3 .* alpha .* x0 .^ 4 - 945 .* x .* kappa .^ 3 .* alpha .^ 3 .* x0 .^ 2 + 540 .* x .* beta .^ 2 .* kappa .^ 2 .* alpha .* x0 .^ 2 + 540 .* x .^ 2 .* beta .^ 2 .* kappa .^ 2 .* alpha .* x0 - 225 .* x .^ 2 .* kappa .^ 3 .* alpha .* x0 .^ 3 + 540 .* kappa .^ 3 .* alpha .^ 4 .* x0 .^ 2 + 35 .* x .^ 3 .* kappa .^ 3 .* x0 .^ 3 + 270 .* x .^ 3 .* beta .^ 2 .* kappa .^ 2 .* alpha - 90 .* x .^ 3 .* beta .^ 2 .* kappa .^ 2 .* x0 - 945 .* x .^ 2 .* kappa .^ 3 .* alpha .^ 3 .* x0 - 45 .* x .^ 5 .* kappa .^ 3 .* alpha + 15 .* x .^ 5 .* kappa .^ 3 .* x0 + 180 .* x .^ 4 .* kappa .^ 3 .* alpha .^ 2 + 30 .* x .^ 4 .* kappa .^ 3 .* x0 .^ 2 - 405 .* x .^ 3 .* kappa .^ 3 .* alpha .^ 3 - 405 .* kappa .^ 3 .* alpha .^ 3 .* x0 .^ 3 + 180 .* kappa .^ 3 .* alpha .^ 2 .* x0 .^ 4 - 405 .* x .* kappa .^ 3 .* alpha .^ 5 + 135 .* x .* beta .^ 4 .* kappa .* alpha + 810 .* x .* beta .^ 2 .* kappa .^ 2 .* alpha .^ 3 + 495 .* x .^ 3 .* kappa .^ 3 .* alpha .^ 2 .* x0 - 225 .* x .^ 3 .* kappa .^ 3 .* alpha .* x0 .^ 2 + 810 .* kappa .^ 2 .* alpha .^ 3 .* beta .^ 2 .* x0 - 675 .* kappa .^ 2 .* alpha .^ 2 .* beta .^ 2 .* x0 .^ 2 - 45 .* kappa .^ 3 .* alpha .* x0 .^ 5 - 135 .* x .^ 4 .* kappa .^ 3 .* alpha .* x0 - 90 .* x .* beta .^ 2 .* kappa .^ 2 .* x0 .^ 3 - 81 .* x .* beta .^ 4 .* kappa .* x0 + 15 .* x .* kappa .^ 3 .* x0 .^ 5 - 675 .* x .^ 2 .* beta .^ 2 .* kappa .^ 2 .* alpha .^ 2 - 405 .* kappa .^ 3 .* alpha .^ 5 .* x0 + 675 .* x .^ 2 .* kappa .^ 3 .* alpha .^ 2 .* x0 .^ 2 + 540 .* x .^ 2 .* kappa .^ 3 .* alpha .^ 4 + 30 .* x .^ 2 .* kappa .^ 3 .* x0 .^ 4 - 135 .* x .^ 2 .* beta .^ 2 .* kappa .^ 2 .* x0 .^ 2) .* kappa .^ 3 ./ beta .^ 6) ./ 0.1080e4;
            end
         end
      end
      sigmaOfx = beta*ones(size(x));
      gammaOfx = x/beta;  gammaOfx0 = x0/beta;  % used only for order == -1
   case 'cir'
      kappa = theta(1);  alpha = theta(2);  beta = theta(3);
      p0 = sqrt(0.2e1) .* (dt .* pi) .^ (-0.1e1 ./ 0.2e1) .* exp(-(0.2e1 .* sqrt(x) ./ beta - 0.2e1 .* sqrt(x0) ./ beta) .^ 2 ./ dt ./ 0.2e1 - x ./ beta .^ 2 .* kappa + kappa .* x0 ./ beta .^ 2) .* (0.2e1 .* sqrt(x) ./ beta) .^ (0.2e1 .* kappa .* alpha ./ beta .^ 2 - 0.1e1 ./ 0.2e1) .* (0.2e1 .* sqrt(x0) ./ beta) .^ (0.1e1 ./ 0.2e1 - 0.2e1 .* kappa .* alpha ./ beta .^ 2) ./ 0.2e1;
      if order>0, c(1,:) = -(0.16e2 .* sqrt(x0) .* kappa .^ 2 .* x .^ (0.3e1 ./ 0.2e1) + 0.16e2 .* x0 .* kappa .^ 2 .* x - 0.96e2 .* sqrt(x) .* sqrt(x0) .* kappa .^ 2 .* alpha + 0.16e2 .* sqrt(x) .* x0 .^ (0.3e1 ./ 0.2e1) .* kappa .^ 2 + (9 .* beta .^ 4) - 0.48e2 .* kappa .* alpha .* (beta .^ 2) + 0.48e2 .* kappa .^ 2 .* alpha .^ 2) ./ (beta .^ 2) .* x0 .^ (-0.1e1 ./ 0.2e1) .* x .^ (-0.1e1 ./ 0.2e1) ./ 0.96e2;
         if order>1, c(2,:) = (-(4608 .* kappa .^ 3 .* alpha .^ 3 .* beta .^ 2) + (2304 .* kappa .^ 4 .* alpha .^ 4) + (256 .* kappa .^ 4 .* x0 .* x .^ 3) + (288 .* kappa .* alpha .* beta .^ 6) + (2016 .* kappa .^ 2 .* alpha .^ 2 .* beta .^ 4) + 0.288e3 .* sqrt(x) .* (beta .^ 4) .* (x0 .^ (0.3e1 ./ 0.2e1)) .* (kappa .^ 2) + 0.288e3 .* (x .^ (0.3e1 ./ 0.2e1)) .* (beta .^ 4) .* sqrt(x0) .* (kappa .^ 2) - (96 .* x .* beta .^ 4 .* x0 .* kappa .^ 2) + (256 .* x .* kappa .^ 4 .* x0 .^ 3) + (768 .* x .^ 2 .* kappa .^ 4 .* x0 .^ 2) + (512 .* x .^ (0.3e1 ./ 0.2e1) .* kappa .^ 4 .* x0 .^ (0.5e1 ./ 0.2e1)) - (3072 .* x .^ 2 .* kappa .^ 4 .* alpha .* x0) + (512 .* kappa .^ 4 .* x0 .^ (0.3e1 ./ 0.2e1) .* x .^ (0.5e1 ./ 0.2e1)) + 0.1536e4 .* (x .^ (0.3e1 ./ 0.2e1)) .* sqrt(x0) .* (kappa .^ 4) .* (alpha .^ 2) - 0.1536e4 .* (x .^ (0.3e1 ./ 0.2e1)) .* (beta .^ 2) .* sqrt(x0) .* (kappa .^ 3) .* alpha - (3072 .* x .^ (0.3e1 ./ 0.2e1) .* kappa .^ 4 .* alpha .* x0 .^ (0.3e1 ./ 0.2e1)) - (135 .* beta .^ 8) + (10752 .* x .* x0 .* kappa .^ 4 .* alpha .^ 2) - (1536 .* x .* beta .^ 2 .* x0 .* kappa .^ 3 .* alpha) - (3072 .* x .* kappa .^ 4 .* alpha .* x0 .^ 2) - 0.1728e4 .* sqrt(x) .* (beta .^ 4) .* sqrt(x0) .* (kappa .^ 2) .* alpha - 0.9216e4 .* sqrt(x) .* sqrt(x0) .* (kappa .^ 4) .* (alpha .^ 3) + 0.1536e4 .* sqrt(x) .* (kappa .^ 4) .* (alpha .^ 2) .* (x0 .^ (0.3e1 ./ 0.2e1)) + 0.9216e4 .* sqrt(x) .* (beta .^ 2) .* sqrt(x0) .* (kappa .^ 3) .* (alpha .^ 2) - 0.1536e4 .* sqrt(x) .* (beta .^ 2) .* (x0 .^ (0.3e1 ./ 0.2e1)) .* (kappa .^ 3) .* alpha) ./ x0 ./ (beta .^ 4) ./ x ./ 0.9216e4;
         end
      end
      sigmaOfx = sqrt(x)*beta;
      gammaOfx = 2*sqrt(x)/beta;  gammaOfx0 = 2*sqrt(x0)/beta;  % used only for order == -1
   case 'bessel'
      kappa = theta;
      p0 = dt .^ (-0.1e1 ./ 0.2e1) .* sqrt(0.2e1) .* pi .^ (-0.1e1 ./ 0.2e1) .* exp(-(sqrt(x) - sqrt(x0)) .^ 2 ./ dt ./ 0.2e1) .* exp(log(x0) ./ 0.4e1 - log(x0) .* kappa ./ 0.4e1 - log(x) ./ 0.4e1 + log(x) .* kappa ./ 0.4e1) ./ 0.2e1;
      if order>0, c(1,:) = -((kappa .^ 2 - 4 .* kappa + 3) .* x0 .^ (-0.1e1 ./ 0.2e1) .* x .^ (-0.1e1 ./ 0.2e1)) ./ 0.8e1;
         if order>1, c(2,:) = ((kappa .^ 4 - 8 .* kappa .^ 3 + 14 .* kappa .^ 2 + 8 .* kappa - 15) ./ x0 ./ x) ./ 0.64e2;
            if order>2, c(3,:) = -((kappa .^ 6 - 12 .* kappa .^ 5 + 25 .* kappa .^ 4 + 120 .* kappa .^ 3 - 341 .* kappa .^ 2 - 108 .* kappa + 315) .* x0 .^ (-0.3e1 ./ 0.2e1) .* x .^ (-0.3e1 ./ 0.2e1)) ./ 0.512e3;
            end
         end
      end
      sigmaOfx = 2*sqrt(x);
      gammaOfx = sqrt(x); gammaOfx0 = sqrt(x0);
   case 'ginzland'
      kappa = theta(1);  alpha = theta(2);  beta = theta(3);
      p0 = dt .^ (-0.1e1 ./ 0.2e1) .* sqrt(0.2e1) .* pi .^ (-0.1e1 ./ 0.2e1) .* exp(-(x ./ beta - x0 ./ beta) .^ 2 ./ dt ./ 0.2e1) .* exp(-kappa .* (x .^ 2 ./ beta .^ 2 - x0 .^ 2 ./ beta .^ 2) ./ 0.2e1 - alpha .* beta .^ 2 .* (x .^ 4 ./ beta .^ 4 - x0 .^ 4 ./ beta .^ 4) ./ 0.4e1) ./ 0.2e1;
      if order>0,
         c(1,:) = -alpha .^ 2 ./ beta .^ 2 .* x .^ 6 ./ 0.14e2 - alpha .^ 2 ./ beta .^ 2 .* x0 .* x .^ 5 ./ 0.14e2 - x .^ 4 ./ beta .^ 2 .* kappa .* alpha ./ 0.5e1 - x .^ 4 ./ beta .^ 2 .* alpha .^ 2 .* x0 .^ 2 ./ 0.14e2 - x .^ 3 ./ beta .^ 2 .* x0 .* kappa .* alpha ./ 0.5e1 - x .^ 3 ./ beta .^ 2 .* x0 .^ 3 .* alpha .^ 2 ./ 0.14e2 + x .^ 2 .* alpha ./ 0.2e1 - x .^ 2 ./ beta .^ 2 .* kappa .^ 2 ./ 0.6e1 - x .^ 2 ./ beta .^ 2 .* x0 .^ 2 .* kappa .* alpha ./ 0.5e1 - x .^ 2 ./ beta .^ 2 .* alpha .^ 2 .* x0 .^ 4 ./ 0.14e2 + x .* alpha .* x0 ./ 0.2e1 - x ./ beta .^ 2 .* kappa .^ 2 .* x0 ./ 0.6e1 - x ./ beta .^ 2 .* x0 .^ 3 .* kappa .* alpha ./ 0.5e1 - x ./ beta .^ 2 .* alpha .^ 2 .* x0 .^ 5 ./ 0.14e2 + kappa ./ 0.2e1 + alpha .* x0 .^ 2 ./ 0.2e1 - kappa .^ 2 .* x0 .^ 2 ./ beta .^ 2 ./ 0.6e1 - kappa .* alpha ./ beta .^ 2 .* x0 .^ 4 ./ 0.5e1 - alpha .^ 2 ./ beta .^ 2 .* x0 .^ 6 ./ 0.14e2;
      end
      sigmaOfx = beta*ones(size(x));
      gammaOfx = x/beta;  gammaOfx0 = x0/beta;  % used only for order == -1
   otherwise
end

try
   switch order
      case -1
         pY = 1/sqrt(2*pi*dt) * exp(-(gammaOfx-gammaOfx0).^2./(2*dt));
      case 0
         pY = p0;
      case 1
         pY = p0.*(1 + c(1,:)*dt);
      case 2
         pY = p0.*(1 + c(1,:)*dt + c(2,:)*dt^2/2);
      case 3
         pY = p0.*(1 + c(1,:)*dt + c(2,:)*dt^2/2 + c(3,:)*dt^3/6);
   end
   p = pY./sigmaOfx;
catch
   p = NaN(size(x));
end

