function out = findIntervalWithSignChange(fh,x,c,dt,sCrit)

% The solution of the saddlepoint equation (i.e. s for which dK/ds = x) 
% lies in:
% (-infty, sCrit) if sCrit > 0, 
% (sCrit, infty) if sCrit < 0, 
% (-infty,infty) if sCrit == NaN (i.e. if there is no singularity in dK/ds)
% This function finds a finite sub-interval in which the root lies.

if ~isnan(sCrit)

   signAtsCrit = sign(sCrit);
 
   % For one boundary, try zero, and if the sign is not different from the 
   % sign at sCrit then away from sCrit until a point is found where the
   % sign is different.
   sa = 0;
   signAtsa = sign(fh(1,c,dt,sa)-x);
   sb = sCrit;
   n = 0;
   while signAtsa == signAtsCrit
      sb = sa;
      sa = -2^n*sCrit;
      signAtsa = sign(fh(1,c,dt,sa)-x);
      n = n+1;
   end
   
   if n == 0 % if n == 0 (i.e. sb == sCrit) then try to move inward of 
             % sCrit so that the objective function is not later evaluated 
             % at this singular point.
      sb = 0.9*sCrit;
      signAtsb = sign(fh(1,c,dt,sb)-x);
      while signAtsb ~= signAtsCrit
         sa = sb;
         sb = sb + (sCrit-sb)*0.9;
         signAtsb = sign(fh(1,c,dt,sb)-x); 
      end
   end

   out = sort([sa sb]);

else

   sa = 0;
   signAtsa = sign(fh(1,c,dt,sa)-x);
   sb = 1;
   signAtsb = sign(fh(1,c,dt,sb)-x);
   
   while signAtsa == signAtsb
      sa = -2*sb;
      signAtsa = sign(fh(1,c,dt,sa)-x);
      if signAtsa ~= signAtsb, break; end
      sb = -2*sa;
      signAtsb = sign(fh(1,c,dt,sb)-x);
   end
   
   out = sort([sa sb]);
   
end