function [y,y0,sigmaOfx] = gammaTransform(model,x,x0,theta)

switch lower(model)
   case 'sin'
      [y,y0,sigmaOfx] = gamma_sin(x,x0,theta);
   case 'cir'
      [y,y0,sigmaOfx] = gamma_cir(x,x0,theta);
   case 'toy'
      [y,y0,sigmaOfx] = gamma_toy(x,x0,theta);
   case 'log'
      [y,y0,sigmaOfx] = gamma_log(x,x0,theta);
   case {'ou','ginzland'}
      [y,y0,sigmaOfx] = gamma_ou(x,x0,theta);
   case 'bessel'
      [y,y0,sigmaOfx] = gamma_bessel(x,x0,theta);
   otherwise
      error(...
         '''model'' must be one of the prescribed models (e.g. ''sin''');
end

% ----------------------------------------------------------------------

function [y,y0,sigmaOfx] = gamma_sin(x,x0,theta)

y = x;
y0 = x0;
sigmaOfx = ones(size(x));

% ----------------------------------------------------------------------

function [y,y0,sigmaOfx] = gamma_cir(x,x0,theta)

beta = theta(3);
y = 2*sqrt(x)/beta;
y0 = 2*sqrt(x0)/beta;
sigmaOfx = beta*sqrt(x);

% ----------------------------------------------------------------------

function [y,y0,sigmaOfx] = gamma_toy(x,x0,theta)

y = x;
y0 = x0;
sigmaOfx = ones(size(x));

% ----------------------------------------------------------------------

function [y,y0,sigmaOfx] = gamma_log(x,x0,theta)

beta = theta(3);
y = -log(x)/beta;
y0 = -log(x)/beta;
sigmaOfx = beta*x;

% ----------------------------------------------------------------------

function [y,y0,sigmaOfx] = gamma_ou(x,x0,theta)

sigma = theta(3);
y = x/sigma;
y0 = x0/sigma;
sigmaOfx = sigma*(ones(size(x)));

% ----------------------------------------------------------------------

function [y,y0,sigmaOfx] = gamma_bessel(x,x0,theta)

kappa = theta;
y = sqrt(x);
y0 = sqrt(x0);
sigmaOfx = 2*sqrt(x);
